/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis.rm;

import filenet.ws.listener.axis.rm.Request;
import filenet.ws.listener.axis.rm.SocketRR;
import filenet.ws.listener.axis.rm.WSRequestForward;
import filenet.ws.listener.utils.Constants;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

class Connection
extends Thread {
    boolean active;
    String fromHost;
    String time;
    Request request = null;
    Socket outSocket = null;
    Thread clientThread = null;
    Thread serverThread = null;
    SocketRR rr1 = null;
    SocketRR rr2 = null;
    protected static final String m_className = "WSRequestForward.Connection";

    public Connection(Request request) {
        this.request = request;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String m_method = "run";
        WSRequestForward.logger.entering(m_className, m_method);
        int myId = WSRequestForward.id++;
        try {
            this.active = true;
            String targetHost = this.request.getTargetHost();
            int targetPort = this.request.getTargetPort();
            int listenPort = Constants.LISTENER_PROPERTY_WSRM_CLIENT_LISTENER_PORT_DEFAULT;
            InputStream tmpIn1 = null;
            OutputStream tmpOut1 = null;
            InputStream tmpIn2 = null;
            OutputStream tmpOut2 = null;
            if (tmpIn1 == null) {
                tmpIn1 = this.request.getInputStream();
            }
            if (this.request != null) {
                tmpOut1 = this.request.getOutputStream();
            }
            if (targetPort == -1) {
                targetPort = 80;
            }
            this.outSocket = new Socket(targetHost, targetPort);
            tmpIn2 = this.outSocket.getInputStream();
            tmpOut2 = this.outSocket.getOutputStream();
            this.rr1 = new SocketRR(this, null, tmpIn1, this.outSocket, tmpOut2);
            this.rr2 = new SocketRR(this, this.outSocket, tmpIn2, null, tmpOut1);
            String response = null;
            while (this.rr1 != null || this.rr2 != null) {
                if (null != this.rr1 && this.rr1.isDone()) {
                    this.rr1 = null;
                }
                if (null != this.rr2 && this.rr2.isDone()) {
                    response = this.rr2.getResponse();
                    this.rr2 = null;
                }
                Connection connection = this;
                synchronized (connection) {
                    this.wait(1000L);
                }
            }
            this.request.doneProcessing(response);
            this.active = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.halt();
            WSRequestForward.logger.exiting(m_className, m_method);
        }
    }

    synchronized void wakeUp() {
        this.notifyAll();
    }

    public void halt() {
        try {
            if (this.rr1 != null) {
                this.rr1.halt();
            }
            if (this.rr2 != null) {
                this.rr2.halt();
            }
            if (this.request != null) {
                // empty if block
            }
            this.request = null;
            if (this.outSocket != null) {
                this.outSocket.close();
            }
            this.outSocket = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove() {
        int index = -1;
        try {
            this.halt();
        }
        catch (Exception e) {
            System.err.println("index:=" + index + this);
            e.printStackTrace();
        }
    }
}

